require( "HiddenObject/script/style.lua" );

HeadingColor	=	Color(131, 167, 184, 255);

TitleFont = {
  standardFont,
  50,
  HeadingColor
};

CloseButtonFont = {
  standardFont,
  28,
  Color(131, 167, 184, 255)
};


CloseGraphics = {
	"HiddenObject/UI/Button/closenormal",
	"HiddenObject/UI/Button/closedown",
	"HiddenObject/UI/Button/closeover"
};


CloseStyle = {
	parent = DefaultStyle,
	font = CloseButtonFont,
	rolloversound = kDefaultButtonOverSound,
	type= kPush,
	graphics = CloseGraphics,
	flags = kVAlignCenter + kHAlignCenter,
};


MakeDialog
{
	-- Name the modal dialog
	name="HiscoresWindow",
	Bitmap
	{
		
		image="HiddenObject/UI/Highscore/frame",
		Bitmap
		{
			x = 50,
			y = 100,
			image="HiddenObject/UI/HighScore/window1",
			name="leftpanel",
		},
		
		Bitmap
		{
			x = 470,
			y = 100,
			image="HiddenObject/UI/HighScore/window2",
			name="Rightpanel",
		},
		Text
		{
			font = TitleFont,
			name = "title",
			x=kCenter,y=0,w=kMax ,h=75,
			flags = kHAlignCenter + kVAlignTop,
			label = "highscores"
		};

		HiscoresWindow
		{
			x = 0, y = 0,
			w = 800, h = 600,
			font = standardFont,
			SubHeadingColor	=	Color(131, 167, 184, 255);
			TextColor		=	Color(131, 167, 184, 255);
		},
		

		SetStyle(CloseStyle),
		Button
		{
			x=kCenter-130,
			y=-53,
			font = CloseButtonFont,
			name="close",
			type = kPush,
			flags = kHAlignCenter + kVAlignCenter,
			label="close",
			command =
				function()
					SwapToModal("HiddenObject/Script/mainmenu.lua")
				end
		};
	},
}